VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} GBFForm 
   Caption         =   "STL /  VRML to GBF"
   ClientHeight    =   2520
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   3780
   OleObjectBlob   =   "GBFForm.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "GBFForm"
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Visualizer ASCII graphic file translator

Option Explicit

Public app As Object
Public VRML As String
Public STL As String
Public ObjectNum As Integer
Public Material As Integer
Public nXyz As Integer, nNormal As Integer
Public filePos As Long
Public numGeom As Integer
Dim xyz(3, 10000) As Double, normal(3, 10000) As Double

Private Function Translate(FileType, inpFile, outFile)
    Dim line As String, outline As String
    Dim fni As Integer, fno As Integer, resp As Integer
    Dim token As String
    Dim intVar As Integer, longVar As Long, objectID As String
    
    'Initialize Object & Material id's
    ObjectNum = 1
    Material = 1
    numGeom = 0
    filePos = 0
    
    fni = FreeFile
    If Dir(inpFile) = "" Then
        resp = MsgBox("Input file not found", vbOKOnly)
        Exit Function
    End If
    Open inpFile For Input As #fni
    
    fno = FreeFile
    If outFile = "" Then
        outFile = "ProDESKTOP.gaf"
    End If
    
    Open outFile For Output As #fno
   
    Input #fni, line
    outline = Left(line, 5)
    If outline = "#VRML" And FileType = VRML Then ' VRML is input
        Print #fno, "#GRAPHICS_FILE"
        Print #fno, "!Generated by Pro/DESKTOP 4 VRML"
        Print #fno, "#CONTROL_OPTIONS"
        Print #fno, "unit = millimeters" ' SJO obtain actual units
        Print #fno, "#END"
     ElseIf outline = "solid" And FileType = STL Then ' STL is input
        Print #fno, "#GRAPHICS_FILE"
        Print #fno, "!Generated by Pro/DESKTOP 4 STL"
        Print #fno, "#CONTROL_OPTIONS"
        Print #fno, "unit = millimeters" ' SJO obtain actual units
        Print #fno, "#END"
        
        ' Start new object
        Print #fno, "#OBJ"
        Print #fno, "object_id = DW_" + Trim(Str(ObjectNum))
        ObjectNum = ObjectNum + 1
    Else
        resp = MsgBox("Input file is not an STL or VRML File.", vbOKOnly)
        Exit Function
    End If
    
    Do While Not EOF(fni)
        If FileType = VRML Then
            ProcessVRML fni, fno, outline
        Else
            ProcessSTL fni, fno, outline
        End If
        
        If Not outline = "" Then
            Print #fno, outline
        End If
    Loop
    
    Print #fno, "#END"
    
    Close #fni
    Close #fno

    Translate = 1
End Function

Private Sub Get3Double(pos, inline, x, y, z)
    Dim xStr As String, yStr As String, zStr As String
    Dim pos2 As Integer, pos3 As Integer
    Dim length As Integer
    
    length = Len(inline)
    pos2 = InStr(pos, inline, " ", 1) ' y
    pos3 = InStr(pos2 + 1, inline, " ", 1) ' z
    
    xStr = Mid(inline, pos, pos2 - pos)
    yStr = Mid(inline, pos2 + 1, pos3 - pos2 - 1)
    zStr = Mid(inline, pos3 + 1, length - pos3)
    x = xStr
    y = yStr
    z = zStr
End Sub

Private Sub Get3Integer(pos, inline, i, j, k)
    Dim iStr As String, jStr As String, kStr As String
    Dim pos2 As Integer, pos3 As Integer
    Dim length As Integer
    
    length = Len(inline)
    pos2 = InStr(pos, inline, " ", 1) ' j
    pos3 = InStr(pos2 + 1, inline, " ", 1) ' k
    
    iStr = Mid(inline, pos, pos2 - pos)
    jStr = Mid(inline, pos2 + 1, pos3 - pos2 - 1)
    kStr = Mid(inline, pos3 + 1, length - pos3)
    i = iStr
    j = jStr
    k = kStr
End Sub

' Input comma delimited to string
Private Sub InputCS(fni, inline)
    Dim a As String, b As String, c As String, d As String
    Input #fni, a, b, c, d
    If d = -1 Then
        inline = a + " " + b + " " + c
    Else
        inline = "]"
    End If
End Sub

Private Sub ProcessVRML(fni, fno, outline)
    Dim token As String, token2 As String, inline As String, resp As String
    Dim xStr As String, yStr As String, zStr As String
    Dim pos As Integer, pos2 As Integer, pos3 As Integer
    Dim pos4 As Integer, pos5 As Integer, length As Integer
    Dim x As Double, y As Double, z As Double
    Dim spec As Integer, colorR As Integer, colorG As Integer, colorB As Integer
    Dim i As Integer, j As Integer, k As Integer
    Dim intVar As Integer, longVar As Long, objectID As String
    
    While inline = ""
        Input #fni, inline
    Wend
    
    length = Len(inline)
    pos = InStr(1, inline, " ", 1)
    token = Left(inline, pos)
    If token = "" Then
        outline = ""
        Exit Sub
    End If
    
    Select Case Trim(token)
    Case "Separator"
        pos2 = InStr(pos, inline, "#", 1) + 1
        token2 = Right(inline, length - pos2)
        If token2 = "solids" Then
            ' Start new object
            Print #fno, "#OBJ"
            Print #fno, "object_id = DW_" + Trim(Str(ObjectNum))
            ObjectNum = ObjectNum + 1
        End If
    
        outline = ""
    Case "Info"
        outline = ""
    Case "string"
        outline = ""
        
    ' Attributes
    Case "Material" 'Not implemented yet
        ' must scan file gathering Material and Color info first
        ' then define in #MATERIAL or #COLOR section of GBF
        
'        Print #fno, "#MATERIAL"
'        Print #fno, "name = VRML" + Trim(Str(Material))
        Material = Material + 1

        While Not inline = "}"
            Input #fni, inline

            pos = InStr(1, inline, " ", 1)
            length = Len(inline)
            token2 = Trim(Left(inline, pos))

            If token2 = "diffuseColor" Then
                'VERIFY(assembly->GetComponentColor(design, color));
                'string.Format("diffuseColor %g %g %g", GetRValue(color)/255.0, GetGValue(color)/255.0, GetBValue(color)/255.0);
            
                'diffuseColor 0.894118 0.831373 0.729412
                Get3Double pos + 1, inline, x, y, z
'                Print #fno, "base_color = (" + Str(x) + " " + Str(y) + " " + Str(z) + ")"
                colorR = x * 256
                colorG = y * 256
                colorB = z * 256

            ElseIf token2 = "specularColor" Then
                'specularColor 0.9 0.9 0.9
                Get3Double pos + 1, inline, x, y, z
                spec = (x + y + z) * 10 / 3
'                Print #fno, "specular_hue = base_color_shades"
'                Print #fno, "specular_intensity = " + Str(spec)
                
            ElseIf token2 = "shininess" Then
                'shininess 0.25
                xStr = Mid(inline, pos + 1, length - pos)
                x = xStr
                spec = x * 10
'                Print #fno, "specular_glare = " + Str(spec)
                
            ElseIf token2 = "" Then
'                Print #fno, "#END"
                Exit Sub
                
            Else
                MsgBox ("Must handle this type of MATERIAL => " + inline)
            End If
        Wend ' While ! }
'        Print #fno, "#END" 'MATERIAL
        
    Case "ShapeHints" ' {
            Input #fni, inline ' shapeType SOLID
            Input #fni, inline ' faceType CONVEX # all facets are triangular
            Input #fni, inline ' vertexOrdering COUNTERCLOCKWISE
            Input #fni, inline ' }
            
    Case "NormalBinding" ' {
            Input #fni, inline ' value PER_VERTEX_INDEXED
            Input #fni, inline ' }
            
    Case "Coordinate3" ' {
            Input #fni, inline ' point [
            ' Gather Nodes for use by IndexedFaceSet
            Input #fni, inline ' x y z
            nXyz = 0
            While Not inline = "]"
                Get3Double 1, inline, xyz(0, nXyz), xyz(1, nXyz), xyz(2, nXyz)
                nXyz = nXyz + 1
                Input #fni, resp ' ending comma
                Input #fni, inline ' x y z
            Wend
            Input #fni, inline ' }
    Case "Normal" ' { not used
            Input #fni, inline ' vector [
            ' Gather Nodes
            Input #fni, inline ' x y z
            nNormal = 0
            While Not inline = "]"
                Get3Double 1, inline, normal(0, nNormal), normal(1, nNormal), normal(2, nNormal)
                nNormal = nNormal + 1
                Input #fni, resp ' ending comma
                Input #fni, inline ' x y z
            Wend
            Input #fni, inline ' }
            
    Case "IndexedFaceSet" ' could be more than one solid
            'coordIndex [
                '0, 4, 1, -1,
                '1, 4, 5, -1,
                '7, 4, 2, -1,
                '....
            ']
            Input #fni, inline ' coordIndex [
            ' Output FP from xyz Nodes
            InputCS fni, inline ' i, j, k, -1,
            While Not inline = "]"
                Get3Integer 1, inline, i, j, k
                Print #fno, "#FP"
                Print #fno, xyz(0, i), xyz(1, i), xyz(2, i)
                Print #fno, xyz(0, j), xyz(1, j), xyz(2, j)
                Print #fno, xyz(0, k), xyz(1, k), xyz(2, k)
                Input #fni, resp ' ending comma
                Print #fno, "#END"
                InputCS fni, inline ' i, j, k, -1,
            Wend
            
            'normalIndex [ 'SJO Do these get used?????????
            '    2, 2, 2, -1,
            '    2, 2, 2, -1,
            '    4, 4, 4, -1,
            '....
            ']
    Case "}"
        pos2 = InStr(pos, inline, "#", 1) + 1
        token2 = Right(inline, length - pos2)
        If token2 = "solids" Then
            Print #fno, "#END" ' OBJ
        End If
        outline = ""
        
    Case Else
        MsgBox ("Case error => " + inline)
        outline = ""
        
    End Select
    
End Sub

Private Sub ProcessSTL(fni, fno, outline)
    Dim token As String, token2 As String, inline As String, resp As String
    Dim xStr As String, yStr As String, zStr As String
    Dim pos As Integer, pos2 As Integer, pos3 As Integer
    Dim pos4 As Integer, pos5 As Integer, length As Integer
    Dim x As Double, y As Double, z As Double
    
    While inline = ""
        Input #fni, inline
    Wend
    
    length = Len(inline)
    pos = InStr(1, inline, " ", 1)
    token = Left(inline, pos)
    If pos = 0 And token = "" Then
        token = inline
    ElseIf token = "" Then
        outline = ""
        Exit Sub
    End If
    
    Select Case Trim(token)
    Case "solid"
        ' start new object
        Print #fno, "#OBJ"
        Print #fno, "object_id = DW_" + Trim(Str(ObjectNum))
        ObjectNum = ObjectNum + 1
        
    Case "outer" ' loop
        Print #fno, "#FP"
        numGeom = numGeom + 1
        
    Case "facet"
        'facet normal 0.998176 -0.0603785 0
        pos2 = InStr(pos + 1, inline, " ", 1) ' normal
        Get3Double pos2 + 1, inline, xyz(0, 0), xyz(1, 0), xyz(2, 0)
        ' Normals not used
'       outline = "normal = " + Str(x) + ", " + Str(y) + ", " + Str(z)
        outline = ""
        
    Case "vertex"
        'vertex -56.1803 15 0
        Get3Double pos + 1, inline, xyz(0, 0), xyz(1, 0), xyz(2, 0)
        Print #fno, xyz(0, 0), xyz(1, 0), xyz(2, 0)
        
    Case "endfacet"
        outline = ""
        
    Case "endloop"
        Print #fno, "#END"
        
    Case "endsolid"
        outline = ""
        Print #fno, "#END"
        
    Case Else
        outline = ""
        
    End Select
    
End Sub

Private Sub CancelButton_Click()
    Update
    Hide
End Sub

Private Sub InputSTLBox_Change()
    If InputVRMLBox.Enabled Then
        InputVRMLBox.Enabled = False
        InputVRMLBox.BackColor = RGB(150, 150, 150)
        VRML = "VRML"
        STL = "STL"
    End If
End Sub

Private Sub InputVRMLBox_Change()
    If InputSTLBox.Enabled Then
        InputSTLBox.Enabled = False
        InputSTLBox.BackColor = RGB(150, 150, 150)
        VRML = "VRML"
        STL = "STL"
    End If
End Sub

Private Sub OKButton_Click()
    Dim inpFile As String, outFile As String
    Dim success As Integer, FileType As String
    
    If Not InputSTLBox = "" Then
        FileType = STL
        success = Translate(FileType, InputSTLBox, OutputBox)
    ElseIf Not InputVRMLBox = "" Then
        FileType = VRML
        success = Translate(FileType, InputVRMLBox, OutputBox)
    End If
    
    Update
    Hide
End Sub

Private Sub OutputBox_Change()

End Sub

Private Sub UserForm_Click()

End Sub
Private Sub Update()
    InputVRMLBox.Enabled = True
    InputSTLBox.Enabled = True
    InputSTLBox.BackColor = RGB(255, 255, 255)
    InputVRMLBox.BackColor = RGB(255, 255, 255)
    InputSTLBox = ""
    InputVRMLBox = ""
    OutputBox = ""
End Sub
